/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.property.region;

import filenet.vw.api.VWAttributeInfo;
import filenet.vw.api.VWSystemConfiguration;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.VWConfigRegionNode;
import filenet.vw.toolkit.admin.images.VWImageLoader;
import filenet.vw.toolkit.admin.property.base.VWConfigWebApplicationPanel;
import filenet.vw.toolkit.admin.property.region.VWConfigLogOptionPane;
import filenet.vw.toolkit.admin.property.region.VWConfigPerformancePane;
import filenet.vw.toolkit.admin.property.region.VWConfigStepProcessorInfoPane;
import filenet.vw.toolkit.admin.property.region.VWConfigWebServicesPanel;
import filenet.vw.toolkit.admin.resources.VWResource;
import filenet.vw.toolkit.utils.VWAccessibilityHelper;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWKeyAdapter;
import filenet.vw.toolkit.utils.VWSessionInfo;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class VWConfigRegionPropertyDialog
extends VWModalDialog
implements ActionListener {
    protected JTabbedPane m_tabbedPanel = new JTabbedPane();
    protected VWConfigPerformancePane m_regionConfigPane = null;
    protected VWConfigLogOptionPane m_logOptionPane = null;
    protected VWConfigStepProcessorInfoPane m_stepProcessorInfoPane = null;
    protected VWConfigWebApplicationPanel m_webApplicationPanel = null;
    protected VWConfigWebServicesPanel m_webServicesPanel = null;
    protected JLabel m_regionIdLabel = new JLabel(VWResource.s_label.toString(VWResource.IsolatedRegionLabel));
    protected JLabel m_regionId = new JLabel();
    protected JLabel m_connectPointLabel = new JLabel(VWResource.s_label.toString(VWResource.ConnectionPoint));
    protected JLabel m_connectionPoint = new JLabel();
    protected JButton m_OKButton = new JButton(VWResource.OK);
    protected JButton m_cancelButton = new JButton(VWResource.Cancel);
    protected JButton m_helpButton = new JButton(VWResource.Help);
    protected VWConfigRegionNode m_rNode = null;
    protected VWSystemConfiguration m_sysConfig = null;
    protected VWAttributeInfo m_vwAttributeInfo = null;
    protected int m_nRetStatus = -1;
    protected Font m_boldFont = null;
    protected boolean m_bIsDirty = false;
    protected VWSessionInfo m_sessionInfo = null;
    protected Frame m_parentFrame = null;
    private boolean m_bDisplayP8Func = true;

    public VWConfigRegionPropertyDialog(Frame parent, VWConfigRegionNode rNode) {
        super(parent);
        this.m_parentFrame = parent;
        try {
            this.m_rNode = rNode;
            this.m_sessionInfo = this.m_rNode.getSessionInfo();
            this.m_sysConfig = rNode.getSystemConfiguration();
            if (this.m_sessionInfo != null) {
                this.m_bDisplayP8Func = this.m_sessionInfo.getDisplayP8BPMFunctionality();
            }
            Font aFont = this.getFont();
            this.m_boldFont = new Font(aFont.getName(), 1, aFont.getSize());
            this.setTitle(VWResource.IsolatedRegionProperties);
            this.getContentPane().setLayout(new BorderLayout(6, 6));
            Dimension dim = VWStringUtils.stringToDimension("825,475");
            if (dim == null) {
                dim = new Dimension(750, 430);
            }
            this.setSize(dim.width, dim.height);
            this.setVisible(false);
            this.m_tabbedPanel.setFont(this.m_boldFont);
            VWAccessibilityHelper.setAccessibility(this.m_tabbedPanel, this, VWResource.GeneralPanelTabbedPane, VWResource.GeneralPanelTabbedPane);
            this.m_tabbedPanel.addKeyListener(VWKeyAdapter.s_keyAdapter);
            this.m_tabbedPanel.add(VWResource.General, this.createGeneralPanel());
            this.m_logOptionPane = new VWConfigLogOptionPane(this.m_sysConfig);
            this.m_tabbedPanel.add(VWResource.EventLogOptions, this.m_logOptionPane);
            this.m_regionConfigPane = new VWConfigPerformancePane(this.m_sysConfig);
            this.m_tabbedPanel.add(VWResource.RegionConfiguration, this.m_regionConfigPane);
            this.m_stepProcessorInfoPane = new VWConfigStepProcessorInfoPane(this.m_parentFrame, this.m_sysConfig, rNode.getSessionInfo());
            this.m_tabbedPanel.add(VWResource.StepProcessorInfo, this.m_stepProcessorInfoPane);
            this.m_vwAttributeInfo = this.m_sysConfig.getAttributeInfo();
            this.m_webApplicationPanel = new VWConfigWebApplicationPanel(this, this.m_vwAttributeInfo, rNode.getSessionInfo());
            this.m_tabbedPanel.add(VWResource.WebApplications, this.m_webApplicationPanel);
            if (this.m_bDisplayP8Func) {
                this.m_webServicesPanel = new VWConfigWebServicesPanel(this.m_parentFrame, this.m_sessionInfo, this.m_vwAttributeInfo);
                this.m_tabbedPanel.add(VWResource.WebServices, this.m_webServicesPanel);
            }
            this.getContentPane().add((Component)this.m_tabbedPanel, "Center");
            this.getContentPane().add((Component)this.createButtonPanel(), "Last");
            this.setLocationRelativeTo(this.m_parentFrame);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void addNotify() {
        super.addNotify();
        this.m_tabbedPanel.requestFocus();
    }

    public int getStatus() {
        return this.m_nRetStatus;
    }

    public boolean isModified() {
        return this.m_bIsDirty;
    }

    public void actionPerformed(ActionEvent event) {
        Object obj = event.getSource();
        if (obj == this.m_cancelButton) {
            try {
                this.m_nRetStatus = 1;
                this.setVisible(false);
            }
            catch (Exception ex) {}
        } else if (obj == this.m_OKButton) {
            try {
                this.m_logOptionPane.update();
                if (this.m_logOptionPane.m_bDirty) {
                    this.m_bIsDirty = true;
                }
                if (!this.m_regionConfigPane.update()) {
                    return;
                }
                if (this.m_regionConfigPane.m_bDirty) {
                    this.m_bIsDirty = true;
                }
                if (!this.m_stepProcessorInfoPane.update()) {
                    return;
                }
                if (this.m_stepProcessorInfoPane.hasChanged()) {
                    this.m_bIsDirty = true;
                }
                if (!this.m_webApplicationPanel.update()) {
                    return;
                }
                if (this.m_webApplicationPanel.hasChanged()) {
                    this.m_bIsDirty = true;
                }
                if (this.m_bDisplayP8Func) {
                    if (!this.m_webServicesPanel.update()) {
                        return;
                    }
                    if (this.m_webServicesPanel.hasChanged()) {
                        this.m_bIsDirty = true;
                    }
                }
                if (this.m_bIsDirty) {
                    this.m_sysConfig.setAttributeInfo(this.m_vwAttributeInfo);
                }
                this.m_nRetStatus = 0;
                this.setVisible(false);
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, ex.getLocalizedMessage(), VWResource.s_error, 0);
                return;
            }
        } else if (obj == this.m_helpButton) {
            VWHelp.displayPage(VWHelp.Help_Process_Config + "bpfc068.htm");
        }
    }

    public void releaseResources() {
        if (this.m_tabbedPanel != null) {
            this.m_tabbedPanel.removeAll();
            this.m_tabbedPanel = null;
        }
        if (this.m_regionConfigPane != null) {
            this.m_regionConfigPane.releaseResources();
            this.m_regionConfigPane = null;
        }
        if (this.m_logOptionPane != null) {
            this.m_logOptionPane.releaseResources();
            this.m_logOptionPane = null;
        }
        if (this.m_stepProcessorInfoPane != null) {
            this.m_stepProcessorInfoPane.releaseResources();
            this.m_stepProcessorInfoPane = null;
        }
        if (this.m_webApplicationPanel != null) {
            this.m_webApplicationPanel.releaseResources();
            this.m_webApplicationPanel = null;
        }
        if (this.m_webServicesPanel != null) {
            this.m_webServicesPanel.releaseResources();
            this.m_webServicesPanel = null;
        }
        if (this.m_regionIdLabel != null) {
            this.m_regionIdLabel.removeAll();
            this.m_regionIdLabel = null;
        }
        if (this.m_regionId != null) {
            this.m_regionId.removeAll();
            this.m_regionId = null;
        }
        if (this.m_connectPointLabel != null) {
            this.m_connectPointLabel.removeAll();
            this.m_connectPointLabel = null;
        }
        if (this.m_connectionPoint != null) {
            this.m_connectionPoint.removeAll();
            this.m_connectionPoint = null;
        }
        if (this.m_OKButton != null) {
            this.m_OKButton.removeActionListener(this);
            this.m_OKButton.removeAll();
            this.m_OKButton = null;
        }
        if (this.m_cancelButton != null) {
            this.m_cancelButton.removeActionListener(this);
            this.m_cancelButton.removeAll();
            this.m_cancelButton = null;
        }
        if (this.m_helpButton != null) {
            this.m_helpButton.removeActionListener(this);
            this.m_helpButton.removeAll();
            this.m_helpButton = null;
        }
        this.m_rNode = null;
        this.m_sysConfig = null;
        this.m_vwAttributeInfo = null;
        this.m_boldFont = null;
        this.removeAll();
    }

    protected JPanel createGeneralPanel() {
        JPanel mainPanel = null;
        GridBagConstraints gbConst = new GridBagConstraints();
        ImageIcon regionIcon = VWImageLoader.createImageIcon("iso_logon_32.gif");
        try {
            mainPanel = new JPanel();
            mainPanel.setLayout(new GridBagLayout());
            gbConst.fill = 2;
            gbConst.anchor = 23;
            gbConst.gridwidth = 1;
            gbConst.gridheight = 1;
            gbConst.weightx = 0.0;
            gbConst.weighty = 0.0;
            gbConst.insets = new Insets(4, 10, 10, 0);
            gbConst.gridx = 0;
            gbConst.gridy = 0;
            JLabel iconLabel = new JLabel(regionIcon, 2);
            VWAccessibilityHelper.setAccessibility(iconLabel, this, VWResource.Region, VWResource.Region);
            mainPanel.add((Component)iconLabel, gbConst);
            gbConst.insets = new Insets(4, 10, 4, 4);
            gbConst.gridx = 0;
            gbConst.gridy = 1;
            gbConst.weightx = 0.0;
            gbConst.weighty = 0.0;
            gbConst.gridwidth = 1;
            this.m_regionIdLabel.setFont(this.m_boldFont);
            mainPanel.add((Component)this.m_regionIdLabel, gbConst);
            VWAccessibilityHelper.setAccessibility(this.m_regionIdLabel, this, this.m_regionIdLabel.getText(), this.m_regionIdLabel.getText());
            this.m_regionIdLabel.addKeyListener(VWKeyAdapter.s_keyAdapter);
            gbConst.insets = new Insets(4, 4, 4, 4);
            gbConst.gridx = 1;
            gbConst.gridwidth = 0;
            this.m_regionId.setText(this.m_rNode.getRegionIDString());
            mainPanel.add((Component)this.m_regionId, gbConst);
            VWAccessibilityHelper.setAccessibility(this.m_regionId, this, this.m_regionId.getText(), this.m_regionId.getText());
            this.m_regionId.addKeyListener(VWKeyAdapter.s_keyAdapter);
            gbConst.insets = new Insets(4, 10, 4, 4);
            gbConst.gridx = 0;
            gbConst.gridy = 2;
            gbConst.gridwidth = 1;
            this.m_connectPointLabel.setFont(this.m_boldFont);
            mainPanel.add((Component)this.m_connectPointLabel, gbConst);
            VWAccessibilityHelper.setAccessibility(this.m_connectPointLabel, this, this.m_connectPointLabel.getText(), this.m_connectPointLabel.getText());
            this.m_connectPointLabel.addKeyListener(VWKeyAdapter.s_keyAdapter);
            gbConst.insets = new Insets(4, 4, 4, 4);
            gbConst.gridx = 1;
            gbConst.gridwidth = 0;
            this.m_connectionPoint.setText(this.m_rNode.getRouterName());
            mainPanel.add((Component)this.m_connectionPoint, gbConst);
            VWAccessibilityHelper.setAccessibility(this.m_connectionPoint, this, this.m_connectionPoint.getText(), this.m_connectionPoint.getText());
            this.m_connectionPoint.addKeyListener(VWKeyAdapter.s_keyAdapter);
            gbConst.gridx = 0;
            gbConst.gridy = 3;
            gbConst.weightx = 1.0;
            gbConst.weighty = 1.0;
            mainPanel.add(Box.createHorizontalStrut(100), gbConst);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return mainPanel;
    }

    protected JPanel createButtonPanel() {
        try {
            JPanel buttonPanel = new JPanel(new FlowLayout(1, 6, 6));
            this.m_OKButton = new JButton(VWResource.OK);
            this.m_OKButton.addActionListener(this);
            VWAccessibilityHelper.setAccessibility(this.m_OKButton, buttonPanel, VWResource.OK, VWResource.OK);
            this.m_OKButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            buttonPanel.add(this.m_OKButton);
            this.m_cancelButton = new JButton(VWResource.Cancel);
            this.m_cancelButton.addActionListener(this);
            VWAccessibilityHelper.setAccessibility(this.m_cancelButton, buttonPanel, VWResource.Cancel, VWResource.Cancel);
            this.m_cancelButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            buttonPanel.add(this.m_cancelButton);
            this.m_helpButton = new JButton(VWResource.Help);
            this.m_helpButton.addActionListener(this);
            VWAccessibilityHelper.setAccessibility(this.m_helpButton, buttonPanel, VWResource.Help, VWResource.Help);
            this.m_helpButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
            buttonPanel.add(this.m_helpButton);
            return buttonPanel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }
}

